/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.codemanipulation.StubUtility;
import org.asnlab.asndt.internal.corext.template.asn.AsnContext;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.dialogs.StatusInfo;
import org.asnlab.asndt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.asnlab.asndt.internal.ui.wizards.NewWizardMessages;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.DialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.Separator;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.StringDialogField;
import org.asnlab.asndt.ui.CodeGeneration;
import org.asnlab.asndt.ui.wizards.NewContainerWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewAsnModulePage
extends NewContainerWizardPage {
    private static final String PAGE_NAME = "NewAsnModulePage";
    private StringDialogField fModuleNameDialogField;
    private SelectionButtonDialogField fAddCommentButton;
    private boolean fUseAddCommentButtonValue;
    protected IStatus fModuleNameStatus;

    public NewAsnModulePage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewModuleWizardPage_title);
        this.setDescription(NewWizardMessages.NewModuleWizardPage_description);
        this.fModuleNameDialogField = new StringDialogField();
        this.fModuleNameDialogField.setLabelText(NewWizardMessages.NewModuleWizardPage_modulename_label);
        this.fAddCommentButton = new SelectionButtonDialogField(32);
        this.fAddCommentButton.setLabelText(NewWizardMessages.NewModuleWizardPage_addcomment_label);
        this.fUseAddCommentButtonValue = false;
        this.fModuleNameStatus = new StatusInfo();
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createModuleNameControls(Composite composite, int nColumns) {
        this.fModuleNameDialogField.doFillIntoGrid(composite, nColumns);
        DialogField.createEmptySpace(composite);
        Text text = this.fModuleNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        TextFieldNavigationHandler.install(text);
    }

    protected void createCommentControls(Composite composite, int nColumns) {
        Link link = new Link(composite, 0);
        link.setText(NewWizardMessages.NewTypeWizardPage_addcomment_description);
        link.setLayoutData((Object)new GridData(4, 2, false, false, nColumns, 1));
        DialogField.createEmptySpace(composite);
        this.fAddCommentButton.doFillIntoGrid(composite, nColumns - 1);
    }

    protected void setFocus() {
        this.fModuleNameDialogField.setFocus();
    }

    public String getModuleName() {
        return this.fModuleNameDialogField.getText();
    }

    public void setModuleName(String name, boolean canBeModified) {
        this.fModuleNameDialogField.setText(name);
        this.fModuleNameDialogField.setEnabled(canBeModified);
    }

    protected String getCompilationUnitName(String moduleName) {
        return String.valueOf(moduleName) + ".asn";
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.isAddComments()) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    public void setAddComments(boolean doAddComments, boolean canBeModified) {
        this.fAddCommentButton.setSelection(doAddComments);
        this.fAddCommentButton.setEnabled(canBeModified);
    }

    public void enableCommentControl(boolean useAddCommentValue) {
        this.fUseAddCommentButtonValue = useAddCommentValue;
    }

    public boolean isAddComments() {
        if (this.fUseAddCommentButtonValue) {
            return this.fAddCommentButton.isSelected();
        }
        ISourceFolder root = this.getSourceFolder();
        IAsnProject project = root != null ? root.getAsnProject() : null;
        return StubUtility.doAddComments(project);
    }

    protected String getTemplate(String name, ICompilationUnit parentCU, int pos) {
        try {
            Template template = AsnPlugin.getDefault().getTemplateStore().findTemplate(name);
            if (template != null) {
                return AsnContext.evaluateTemplate(template, parentCU, pos);
            }
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
        catch (TemplateException e) {
            AsnPlugin.log(e);
        }
        return null;
    }

    public void init(IStructuredSelection selection) {
        IAsnElement aelem = this.getInitialAsnElement(selection);
        this.initContainerPage(aelem);
        this.doStatusUpdate();
        this.fModuleNameDialogField.setFocus();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fModuleNameStatus};
        this.updateStatus(status);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createModuleNameControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.asnlab.asndt.ui.new_module_wizard_page_context");
    }

    public IAsnElement getCreatedCompilationUnit() {
        String moduleName = this.getModuleName();
        String compilationUnitName = this.getCompilationUnitName(moduleName);
        ISourceFolder sourceFolder = this.getSourceFolder();
        return sourceFolder.getCompilationUnit(compilationUnitName);
    }

    public void createModule(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String moduleName = this.getModuleName();
        String compilationUnitName = this.getCompilationUnitName(moduleName);
        try {
            monitor.beginTask("Creating " + compilationUnitName, 2);
            IFile file = (IFile)this.getModifiedResource();
            try {
                InputStream stream = this.openContentStream(moduleName);
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                stream.close();
            }
            catch (IOException iOException) {}
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public IResource getModifiedResource() {
        ISourceFolder sourceFolder = this.getSourceFolder();
        IResource resource = sourceFolder.getResource();
        IContainer container = (IContainer)resource;
        String moduleName = this.getModuleName();
        String compilationUnitName = this.getCompilationUnitName(moduleName);
        return container.getFile((IPath)new Path(compilationUnitName));
    }

    private InputStream openContentStream(String moduleName) {
        StringBuffer contents = new StringBuffer();
        boolean addComments = this.isAddComments();
        if (addComments) {
            contents.append("/**").append("\n");
            contents.append(" * Creator: ASNDT (https://www.asnlab.org)").append("\n");
            contents.append(" * Author: ").append(System.getProperty("user.name")).append("\n");
            contents.append(" * Created: ").append(Calendar.getInstance().getTime().toString()).append("\n");
            contents.append(" */").append("\n");
        }
        contents.append(moduleName);
        contents.append(" DEFINITIONS AUTOMATIC TAGS ::= BEGIN").append("\n");
        contents.append("\n");
        if (addComments) {
            contents.append("-- imports and exports").append("\n");
            contents.append("\n");
        }
        contents.append("EXPORTS ;").append("\n");
        contents.append("IMPORTS ;").append("\n");
        contents.append("\t").append("\n");
        if (addComments) {
            contents.append("\t-- type assignments");
            contents.append("\t").append("\n");
        }
        contents.append("\t").append("\n");
        contents.append("\t").append("\n");
        if (addComments) {
            contents.append("\t-- value assignments");
            contents.append("\t").append("\n");
        }
        contents.append("\t").append("\n");
        contents.append("\t").append("\n");
        contents.append("END");
        contents.append("\n");
        return new ByteArrayInputStream(contents.toString().getBytes());
    }
}

