/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.cli.Option;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class FileCleaner {
    static Collection trackers;
    static ReferenceQueue q;
    static Thread reaper;
    static volatile boolean exitWhenFinished;

    public static void track(String a2, Object a3) {
        FileCleaner.track(a2, a3, (FileDeleteStrategy)null);
    }

    public static void track(String a2, Object a3, FileDeleteStrategy a4) {
        if (a2 == null) {
            throw new NullPointerException(ThresholdingOutputStream.K("U-deq$u-!(t6ueo*uec !+t)m"));
        }
        FileCleaner.addTracker(a2, a3, a4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void exitWhenFinished() {
        exitWhenFinished = true;
        if (reaper != null) {
            Thread thread = reaper;
            synchronized (thread) {
                reaper.interrupt();
                return;
            }
        }
    }

    private static synchronized /* synthetic */ void addTracker(String a2, Object a3, FileDeleteStrategy a4) {
        if (exitWhenFinished) {
            throw new IllegalStateException(CopyUtils.K("\u000ec`b%{`x2m#g%~3,#m.,\"i`m$h%h`c.o%,%t)x\u0017d%b\u0006e.e3d%hh%`e3,#m,`%h"));
        }
        if (reaper == null) {
            reaper = new Reaper();
            reaper.start();
        }
        trackers.add(new Tracker(a2, a4, a3, q));
    }

    public static int getTrackCount() {
        return trackers.size();
    }

    public FileCleaner() {
        FileCleaner a2;
    }

    public static void track(File a2, Object a3) {
        FileCleaner.track(a2, a3, (FileDeleteStrategy)null);
    }

    static {
        q = new ReferenceQueue();
        trackers = new Vector();
        exitWhenFinished = false;
    }

    public static void track(File a2, Object a3, FileDeleteStrategy a4) {
        if (a2 == null) {
            throw new NullPointerException(ThresholdingOutputStream.K("U-deg,m !(t6ueo*uec !+t)m"));
        }
        FileCleaner.addTracker(a2.getPath(), a3, a4);
    }

    static final class Tracker
    extends PhantomReference {
        private final /* synthetic */ String path;
        private final /* synthetic */ FileDeleteStrategy deleteStrategy;

        Tracker(String a2, FileDeleteStrategy a3, Object a4, ReferenceQueue a5) {
            Tracker a6;
            Tracker tracker = a6;
            super(a4, a5);
            tracker.path = a2;
            tracker.deleteStrategy = a3 == null ? FileDeleteStrategy.NORMAL : a3;
        }

        public boolean delete() {
            Tracker a2;
            return a2.deleteStrategy.deleteQuietly(new File(a2.path));
        }
    }

    static final class Reaper
    extends Thread {
        Reaper() {
            Reaper a2;
            Reaper reaper = a2;
            super(Option.K("E\u0006o\n#=f\u000es\nq"));
            reaper.setPriority(10);
            reaper.setDaemon(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!exitWhenFinished || trackers.size() > 0) {
                Tracker tracker = null;
                try {
                    tracker = (Tracker)q.remove();
                }
                catch (Exception exception) {
                    continue;
                }
                if (tracker == null) continue;
                tracker.delete();
                tracker.clear();
                trackers.remove(tracker);
            }
        }
    }
}

