/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.core.asn;

import java.math.BigInteger;
import org.asnlab.asndt.core.asn.Exclusion;
import org.asnlab.asndt.core.asn.IntegerRange;
import org.asnlab.asndt.core.asn.Intersection;
import org.asnlab.asndt.core.asn.PermittedAlphabet;
import org.asnlab.asndt.core.asn.Serial;
import org.asnlab.asndt.core.asn.SizeConstraint;
import org.asnlab.asndt.core.asn.Union;

public abstract class ElementSet
implements Cloneable {
    public static ElementSet safeNot(ElementSet a2) {
        if (a2 == null) {
            return a2;
        }
        return a2.not();
    }

    public ElementSet not() {
        ElementSet a2;
        return new Exclusion(a2);
    }

    public ElementSet() {
        ElementSet a2;
    }

    public static ElementSet safeSerial(ElementSet a2, ElementSet a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        return new Serial(a2, a3);
    }

    public static ElementSet safeIntersection(ElementSet a2, ElementSet a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        return new Intersection(a2, a3);
    }

    public static BigInteger safeMax(BigInteger a2, BigInteger a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        if (a2.compareTo(a3) > 0) {
            return a2;
        }
        return a3;
    }

    public static BigInteger safeMin(BigInteger a2, BigInteger a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        if (a2.compareTo(a3) < 0) {
            return a2;
        }
        return a3;
    }

    public SizeConstraint reduceEffectiveSizeConstraint() {
        return null;
    }

    public static ElementSet safeUnion(ElementSet a2, ElementSet a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        return new Union(a2, a3);
    }

    public PermittedAlphabet reduceEffectivePermittedAlphabet() {
        return null;
    }

    public ElementSet simplify() {
        ElementSet a2;
        return a2;
    }

    public IntegerRange reduceEffectiveIntegerRange() {
        return null;
    }

    public static String K(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = (2 ^ 5) << 4 ^ (3 ^ 5) << 1;
        int cfr_ignored_0 = 5 << 3 ^ (2 ^ 5);
        int n5 = n3;
        int n6 = 5 << 4 ^ 2 << 1;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public ElementSet intersection(ElementSet a2) {
        ElementSet a3;
        if (a2 == null) {
            return a3;
        }
        return new Intersection(a3, a2);
    }

    public ElementSet union(ElementSet a2) {
        ElementSet a3;
        if (a2 == null) {
            return a3;
        }
        return new Union(a3, a2);
    }
}

