/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.AsnHeuristicScanner;
import org.asnlab.asndt.internal.ui.text.AsnIndenter;
import org.asnlab.asndt.internal.ui.text.AsnPartitionScanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class AsnAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;
    private final IAsnProject fProject;

    public AsnAutoIndentStrategy(String partitioning, IAsnProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
    }

    private int getBracketCount(IDocument d, int startOffset, int endOffset, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketCount = 0;
        block7: while (startOffset < endOffset) {
            char curr = d.getChar(startOffset);
            ++startOffset;
            switch (curr) {
                case '/': {
                    if (startOffset >= endOffset) break;
                    char next = d.getChar(startOffset);
                    if (next == '*') {
                        startOffset = this.getCommentEnd(d, startOffset + 1, endOffset);
                        break;
                    }
                    if (next != '/') break;
                    startOffset = endOffset;
                    break;
                }
                case '*': {
                    char next;
                    if (startOffset >= endOffset || (next = d.getChar(startOffset)) != '/') continue block7;
                    bracketCount = 0;
                    ++startOffset;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketCount;
                    break;
                }
                case '\"': 
                case '\'': {
                    startOffset = this.getStringEnd(d, startOffset, endOffset, curr);
                }
            }
        }
        return bracketCount;
    }

    private int getCommentEnd(String source, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = source.charAt(offset);
            if (curr != '*' || ++offset >= endOffset || source.charAt(offset) != '/') continue;
            return offset + 1;
        }
        return endOffset;
    }

    private int getCommentEnd(IDocument d, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            if (curr != '*' || ++offset >= endOffset || d.getChar(offset) != '/') continue;
            return offset + 1;
        }
        return endOffset;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(String source, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = source.charAt(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private int getStringEnd(IDocument d, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            AsnHeuristicScanner scanner = new AsnHeuristicScanner(d);
            AsnIndenter indenter = new AsnIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, true, false, false))) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        AsnHeuristicScanner scanner = new AsnHeuristicScanner(d);
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line = d.getLineOfOffset(p);
            int lineOffset = d.getLineOffset(line);
            if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine < line) {
                AsnIndenter indenter = new AsnIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        AsnHeuristicScanner scanner = new AsnHeuristicScanner(d);
        AsnIndenter indenter = new AsnIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int firstCharPos;
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)start, (boolean)true);
            if ("__asn_asndoc".equals(region.getType())) {
                start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            if (this.getBracketCount(d, start, c.offset, true) > 0 && this.closeBrace() && !this.isClosed(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                if (lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}' && (firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start)) != -1 && d.getChar(firstCharPos) == '{') {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                if (reference != null) {
                    buf.append(reference);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
    }

    private boolean isClosed(IDocument document, int offset, int length) {
        IRegion sourceRange;
        block12: {
            AsnHeuristicScanner scanner = new AsnHeuristicScanner(document);
            sourceRange = scanner.findSurroundingBlock(offset);
            if (sourceRange != null) break block12;
            return false;
        }
        try {
            String source = document.get(sourceRange.getOffset(), sourceRange.getLength());
            int bracketCount = 0;
            int startOffset = 0;
            int endOffset = source.length();
            block10: while (startOffset < endOffset) {
                char curr = source.charAt(startOffset);
                ++startOffset;
                switch (curr) {
                    case '/': {
                        if (startOffset >= endOffset) break;
                        char next = source.charAt(startOffset);
                        if (next == '*') {
                            startOffset = this.getCommentEnd(source, startOffset + 1, endOffset);
                            break;
                        }
                        if (next != '/') break;
                        startOffset = endOffset;
                        break;
                    }
                    case '*': {
                        char next;
                        if (startOffset >= endOffset || (next = source.charAt(startOffset)) != '/') continue block10;
                        bracketCount = 0;
                        ++startOffset;
                        break;
                    }
                    case '{': {
                        ++bracketCount;
                        break;
                    }
                    case '}': {
                        --bracketCount;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        startOffset = this.getStringEnd(source, startOffset, endOffset, curr);
                    }
                }
            }
            return bracketCount == 0;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static void installAsnStuff(Document document) {
        String[] types = new String[]{"__asn_multiline_comment", "__asn_singleline_comment", "__asn_string", "__asn_character", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AsnPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("___asn_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeAsnStuff(Document document) {
        document.setDocumentPartitioner("___asn_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            AsnHeuristicScanner scanner = new AsnHeuristicScanner(document);
            AsnIndenter indenter = new AsnIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            peerOffset = indenter.findReferencePosition(peerOffset);
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            IRegion refLine = document.getLineInformationOfOffset(refOffset);
            String prefix = document.get(refLine.getOffset(), newOffset - refLine.getOffset());
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new AsnHeuristicScanner((IDocument)temp);
            indenter = new AsnIndenter((IDocument)temp, scanner, this.fProject);
            AsnAutoIndentStrategy.installAsnStuff(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            boolean changed = false;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = AsnAutoIndentStrategy.getCurrentIndent(temp, l);
                        StringBuffer correct = indenter.computeIndentation(lineOffset);
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition);
                        if (l != first && temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            AsnAutoIndentStrategy.removeAsnStuff(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        AsnAutoIndentStrategy.addIndent(temp, l, addition);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
    }

    private static String getCurrentIndent(Document document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(LINE_COMMENT)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && (type = TextUtilities.getContentType((IDocument)document, (String)"___asn_partitioning", (int)to, (boolean)true)).equals("__asn_multiline_comment")) {
            --to;
        }
        return document.get(from, to - from);
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference) {
        int c2;
        int c1 = this.computeVisualLength(correct);
        int diff = c1 - (c2 = this.computeVisualLength(current));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c);
        }
        return diff;
    }

    private static void addIndent(Document document, int line, CharSequence indent) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (insert < endOffset - 2 && document.get(insert, 2).equals(LINE_COMMENT)) {
            insert += 2;
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, null);
    }

    private int computeVisualLength(CharSequence seq) {
        int size = 0;
        int tablen = this.getVisualTabLengthPreference();
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch) {
        if (ch == '\t') {
            return this.getVisualTabLengthPreference();
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return 4;
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        AsnAutoIndentStrategy.installAsnStuff(pasted);
        int firstPeer = command.offset;
        AsnHeuristicScanner pScanner = new AsnHeuristicScanner((IDocument)pasted);
        AsnHeuristicScanner dScanner = new AsnHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block15: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = AsnAutoIndentStrategy.skipScope(pScanner, pPos, token)) != -1) continue block15;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    AsnIndenter indenter = new AsnIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(AsnHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument d, DocumentCommand c) {
        if (c.offset < 4 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 3, 3);
            if (content.equals("els")) {
                AsnHeuristicScanner scanner = new AsnHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    AsnIndenter indenter = new AsnIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(d, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                AsnHeuristicScanner scanner = new AsnHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    AsnIndenter indenter = new AsnIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1024 ? this.getIndentOfLine(d, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            AsnPlugin.log(e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && AsnAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return AsnPlugin.getDefault().getCombinedPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void clearCachedValues() {
        IPreferenceStore preferenceStore = AsnAutoIndentStrategy.getPreferenceStore();
        this.fCloseBrace = preferenceStore.getBoolean("closeBraces");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean computeSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = AsnPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }
}

